<?php

use App\Models\User;
use App\Models\Role;
use App\Models\Permission;
use App\Models\Speciality;
use App\Models\Doctor;
use App\Models\Patient;
use App\Models\Service;
use App\Models\TermsAndCondition;
use Diglactic\Breadcrumbs\Breadcrumbs;
use Diglactic\Breadcrumbs\Generator as BreadcrumbTrail;

Breadcrumbs::for('dashboard', function (BreadcrumbTrail $trail): void {
    $trail->push('Dashboard', route('dashboard'));
});
//============================= Users/Profile ============================
Breadcrumbs::for('users.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Users', route('users.index'));
});

Breadcrumbs::for('users.edit', function (BreadcrumbTrail $trail, User $user): void {
    $trail->parent('users.index');
    $trail->push('Edit User', route('users.edit', $user));
});

Breadcrumbs::for('users.show', function (BreadcrumbTrail $trail, User $user): void {
    $trail->parent('users.index');
    $trail->push('edit user', route('users.show', $user));
});

Breadcrumbs::for('addUser', function (BreadcrumbTrail $trail): void {
    $trail->parent('users.index');
    $trail->push('Add User', route('addUser'));
});

Breadcrumbs::for('profile', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Profile', route('profile'));
});

Breadcrumbs::for('editProfile', function (BreadcrumbTrail $trail, $profileID): void {
    $trail->parent('profile');
    $trail->push('Edit Profile', route('editProfile', $profileID));
});

//============================= Speciality ============================
Breadcrumbs::for('specialities.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('specialities', route('specialities.index'));
});

Breadcrumbs::for('specialities.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('specialities', route('specialities.create'));
});

Breadcrumbs::for('specialities.edit', function (BreadcrumbTrail $trail, Speciality $specialityId): void {
    $trail->parent('specialities.index');
    $trail->push('Edit Speciality', route('specialities.edit', $specialityId));
});

Breadcrumbs::for('specialities.show', function (BreadcrumbTrail $trail, Speciality $specialityId): void {
    $trail->parent('specialities.index');
    $trail->push('Speciality', route('specialities.show', $specialityId));
});

//============================= Doctors ============================
Breadcrumbs::for('doctors.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('doctors', route('doctors.index'));
});

Breadcrumbs::for('doctors.requests', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('doctors', route('doctors.requests'));
});

Breadcrumbs::for('doctors.show', function (BreadcrumbTrail $trail, Doctor $doctorId): void {
    $trail->parent('doctors.index');
    $trail->push('Doctor ' . $doctorId->name, route('doctors.show', $doctorId));
});

Breadcrumbs::for('doctors.editDoctor', function (BreadcrumbTrail $trail, $doctorId): void {
    $trail->parent('doctors.index');
    $trail->push('Edit Doctor ', route('doctors.editDoctor', $doctorId));
});

Breadcrumbs::for('doctors.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Create Doctor', route('doctors.create'));
});

//============================= Patients ============================
Breadcrumbs::for('patients.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('patients', route('patients.index'));
});

Breadcrumbs::for('patients.show', function (BreadcrumbTrail $trail, Patient $patientId): void {
    $trail->parent('patients.index');
    $trail->push('Patient ' . $patientId->name, route('patients.show', $patientId));
});

Breadcrumbs::for('patients.edit', function (BreadcrumbTrail $trail, Patient $patientId): void {
    $trail->parent('patients.index');
    $trail->push('Patient ' . $patientId->name, route('patients.edit', $patientId));
});


//============================= Services ============================

Breadcrumbs::for('services.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Services', route('services.index'));
});
Breadcrumbs::for('services.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('services.index');
    $trail->push('Create Services', route('services.create'));
});
Breadcrumbs::for('services.edit', function (BreadcrumbTrail $trail, $serviceId): void {
    $trail->parent('services.index');
    $trail->push('Edit Service', route('services.edit', $serviceId));
});

//============================= clinics ============================
Breadcrumbs::for('clinics.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Clinics', route('clinics.index'));
});
Breadcrumbs::for('clinics.show', function (BreadcrumbTrail $trail, $clinicId): void {
    $trail->parent('clinics.index');
    $trail->push('view Clinic', route('clinics.show', $clinicId));
});
Breadcrumbs::for('clinics.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('clinics.index');
    $trail->push('Create Clinic', route('clinics.create'));
});
Breadcrumbs::for('clinics.edit', function (BreadcrumbTrail $trail, $clinicId): void {
    $trail->parent('clinics.index');
    $trail->push('Edit Clinic', route('clinics.edit', $clinicId));
});
Breadcrumbs::for('clinics.assign', function (BreadcrumbTrail $trail): void {
    $trail->parent('clinics.index');
    $trail->push('Assign Doctor To Clinic', route('clinics.assign'));
});
Breadcrumbs::for('clinicsAssign.store', function (BreadcrumbTrail $trail): void {
    $trail->parent('clinics.index');
    $trail->push('store Doctor To Clinic', route('clinicsAssign.store'));
});

//============================= hospitals ============================
Breadcrumbs::for('hospitals.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Hospitals', route('hospitals.index'));
});
Breadcrumbs::for('hospitals.show', function (BreadcrumbTrail $trail, $hospitalId): void {
    $trail->parent('hospitals.index');
    $trail->push('view Hospital', route('hospitals.show', $hospitalId));
});
Breadcrumbs::for('hospitals.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('hospitals.index');
    $trail->push('Create Hospital', route('hospitals.create'));
});
Breadcrumbs::for('hospitals.edit', function (BreadcrumbTrail $trail, $hospitalId): void {
    $trail->parent('hospitals.index');
    $trail->push('Edit Hospital', route('hospitals.edit', $hospitalId));
});

Breadcrumbs::for('hospitals.assign', function (BreadcrumbTrail $trail): void {
    $trail->parent('hospitals.index');
    $trail->push('Assign Doctor To Hospital', route('hospitals.assign'));
});

//============================= contacts ============================
Breadcrumbs::for('contacts.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Contacts', route('contacts.index'));
});


Breadcrumbs::for('contacts.destroy', function (BreadcrumbTrail $trail, $contactlId): void {
    $trail->parent('dashboard');
    $trail->push('Contacts', route('contacts.destroy', $contactlId));
});

//============================= Terms and Conditions ============================
Breadcrumbs::for('terms.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Terms & Conditions', route('terms.index'));
});

Breadcrumbs::for('terms.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('terms.index');
    $trail->push('Create Terms & Conditions', route('terms.create'));
});

Breadcrumbs::for('terms.show', function (BreadcrumbTrail $trail, TermsAndCondition $term): void {
    $trail->parent('terms.index');
    $trail->push('View Terms & Conditions', route('terms.show', $term));
});

Breadcrumbs::for('terms.edit', function (BreadcrumbTrail $trail, TermsAndCondition $term): void {
    $trail->parent('terms.index');
    $trail->push('Edit Terms & Conditions', route('terms.edit', $term));
});

//============================= Slider ============================
Breadcrumbs::for('sliders.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('sliders', route('sliders.index'));
});
Breadcrumbs::for('sliders.show', function (BreadcrumbTrail $trail, $sliderlId): void {
    $trail->parent('sliders.index');
    $trail->push('view Slider', route('sliders.show', $sliderlId));
});
Breadcrumbs::for('sliders.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('sliders.index');
    $trail->push('Create Slider', route('sliders.create'));
});
Breadcrumbs::for('sliders.edit', function (BreadcrumbTrail $trail, $sliderlId): void {
    $trail->parent('sliders.index');
    $trail->push('Edit Slider', route('sliders.edit', $sliderlId));
});
