@extends ('../welcome')


@section ('content')
<?php
    $pagename = 'Users';
?>
<!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><strong>All Users</strong></h3>
                    <div class="col-md-2" style="float:right;">
                        @if(auth()->user()->type =="admin")
                        <a href="{{route('addUser')}}">
                            <button type="button" title="Add User" class="btn btn-success">
                               Add New
                            </button>
                        </a>
                        @endif
                    </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body table-responsive p-0" style="height: 300px;">
                <table class="table table-head-fixed text-nowrap">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Pnone</th>
                            <th>Type</th>
                            <th>Created at</th>
                            <th>Control</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $user)
                        <tr>
                            <td>{{$user->id}}</td>
                            <td>
                                <a href="{{ route('users.show',$user->id) }}">
                                    {{$user->name}}
                                </a>
                            </td>
                            <td>{{$user->email}}</td>
                            <td>{{$user->phone}}</td>
                            <td>{{$user->type}}</td>
                            <td>{{$user->created_at}}</td>
                            <td>
                                <form action="{{ route('users.destroy',$user->id) }}" method="POST">
                                    {{-- @if(auth()->user()->type =="admin")
                                    <a class="btn btn-primary" title="Edit" href="{{ route('users.edit',$user->id) }}">
                                        <i class="fa fa-pen"></i>
                                    </a>
                                    @endif --}}
                                    @csrf
                                    @method('DELETE')
                                    @if(auth()->user()->type =="admin")
                                    <button type="submit" title="Delete" class="btn btn-danger">
                                        <i class="fa fa-ban"></i>
                                    </button>
                                    @endif
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
<!-- /.row -->
@endsection
