@extends ('../welcome')


@section('content')

    <body class="hold-transition register-page">
        <div class="register-box">
            <div class="card">
                <div class="card-body register-card-body">
                    <p class="login-box-msg">Add new membership</p>

                    <form action="{{ route('storeUser') }}" method="POST">
                        @csrf
                        <div class="input-group mb-3">
                            <input type="text" name="name" class="form-control" placeholder="Full name" required
                                autofocus>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-user"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="email" class="form-control" placeholder="Email" name="email" require>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-envelope"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="tel" class="form-control" placeholder="Phone" name="phone" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-phone"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <select name="type" id="type" class="form-control" aria-placeholder="Select Type"
                                required>
                                <option hidden value="">Select Type</option>
                                <option value="Doctor">Doctor</option>
                                <option value="Patient">Patient</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-users"></span>
                                </div>
                            </div>

                        </div>
                        <div class="input-group mb-3">
                            <input class="form-control" placeholder="Password" type="password" name="password" required
                                autocomplete="new-password">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <input type="password" class="form-control" placeholder="Retype password" type="password"
                                name="password_confirmation" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="userRole">Select User Role</label>
                            <select name="roles[]" class="select2 custom-select form-control-border" multiple="multiple"
                                id="userRole">
                                @foreach ($roles as $role)
                                    @if ($role->name == 'user')
                                        <option value="{{ $role->id }}" selected>{{ $role->display_name }}</option>
                                    @else
                                        <option value="{{ $role->id }}">{{ $role->display_name }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="userPermissions">Select User Permission</label>
                            <select name="permissions[]" class="select2 custom-select form-control-border"
                                multiple="multiple" id="userPermissions">
                                @foreach ($permissions as $permission)
                                    <option value="{{ $permission->id }}">{{ $permission->display_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6" style="float:right;">
                            <button type="submit" class="btn btn-primary">Add Member</button>
                        </div>
                        <!-- /.col -->
                    </form>
                </div>
            </div>
            <!-- /.form-box -->
        </div><!-- /.card -->
        <!-- /.register-box -->
    </body>
@endsection
