@extends ('../welcome')

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">Terms and Conditions Details</h3>
            <div>
                <a href="{{ route('terms.edit', $term->id) }}" class="btn btn-primary btn-sm">
                    <i class="fa fa-edit"></i> Edit
                </a>
                <a href="{{ route('terms.index') }}" class="btn btn-secondary btn-sm">
                    <i class="fa fa-arrow-left"></i> Back
                </a>
            </div>
        </div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-6">
                    <strong>Type:</strong>
                    @if($term->identifier == 'terms')
                        <span class="badge badge-info">Terms & Conditions</span>
                    @elseif($term->identifier == 'privacy')
                        <span class="badge badge-warning">Privacy Policy</span>
                    @else
                        <span class="badge badge-secondary">{{ $term->identifier }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <strong>Status:</strong>
                    @if ($term->is_active)
                        <span class="badge badge-success">Active</span>
                    @else
                        <span class="badge badge-secondary">Inactive</span>
                    @endif
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <strong>Created At:</strong> {{ $term->created_at->format('Y-m-d H:i:s') }}
                </div>
                <div class="col-md-6">
                    <strong>Updated At:</strong> {{ $term->updated_at->format('Y-m-d H:i:s') }}
                </div>
            </div>

            <hr>

            <div class="card card-primary card-outline mb-3">
                <div class="card-header">
                    <h4 class="card-title">English Content</h4>
                </div>
                <div class="card-body">
                    <h5>{{ $term->title }}</h5>
                    <div class="mt-3">
                        {!! $term->body !!}
                    </div>
                </div>
            </div>

            @if ($term->title_ar || $term->body_ar)
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h4 class="card-title">Arabic Content</h4>
                    </div>
                    <div class="card-body" dir="rtl">
                        <h5>{{ $term->title_ar }}</h5>
                        <div class="mt-3">
                            {!! $term->body_ar !!}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection

