@extends ('../welcome')


@section ('content')
<div class="col-12">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"><strong>Services</strong></h4>
                <div class="col-md-2" style="float:right;">
                    @if(auth()->user()->type =="admin")
                    <a href="{{route('services.create')}}">
                        <button type="button" title="Add User" class="btn btn-success">
                           Add New
                        </button>
                    </a>
                    @endif
                </div>
        </div>
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th class="filters">#</th>
                        <th class="filters">Name</th>
                        <th class="filters">description</th>
                        <th class="filters">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($services as $service)
                    <tr>
                        <td>{{$loop->iteration}}</td>
                        <td>{{$service->name}} </td>
                        <td>{{$service->description}} </td>
                        <td style="text-align:center;">
                            <div class="row">

                                <a class="btn btn-warning ml-2" title="edit"
                                href="{{route('services.edit' , $service->id)}}" >
                                <i class="fa fa-pen"> </i>
                                </a>

                                <a class="btn btn-danger ml-2" title="Delete"
                                href="{{route('services.delete' , $service->id)}}" >
                                    <i class="fa fa-trash"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection
