@extends ('../welcome')

@section('content')
    <img src="{{ $patient->getFirstMediaUrl($patient->phone) ?: asset('images/patient.jpg') }}" width="120px">

    <div class="card-body">
        <div class=" row">
            <label class="col-sm-2 col-form-label">Name :</label>
            <label class="col-sm-4 col-form-label">{{ $patient->name }} </label>
        </div>

        <div class=" row">
            <label class="col-sm-2 col-form-label">phone :</label>
            <label class="col-sm-4 col-form-label">{{ $patient->phone }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">email :</label>
            <label class="col-sm-4 col-form-label">{{ $patient->email }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">gender :</label>
            <label class="col-sm-4 col-form-label">{{ $patient->gender }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">birthdate :</label>
            <label class="col-sm-4 col-form-label">{{ $patient->birthdate }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">address :</label>
            <label class="col-sm-4 col-form-label">{{ $patient->address }} </label>
        </div>
    </div>

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Patient</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to Reject this Patient ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('doctors.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
