@extends ('../welcome')
<!-- namespace App; -->


@section('content')
    <div class="card">
        <div class="card-body register-card-body mt-5 ml-4">

            <form action="{{ route('patients.update', $patient->id) }}" method="POST">
                @csrf
                @method('put')
                <input type="hidden" value="{{ $patient->id }}" name="id">
                <div class="row">
                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-10">
                                <label>Name</label>
                                <input type="text" name="name" value="{{ old('name', $patient->name) }}"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-5">
                                <label>Phone</label>
                                <input type="tel" class="form-control" value="{{ old('phone', $patient->phone) }}"
                                    name="phone">
                            </div>
                            <div class="form-group col-5">
                                <label>Email</label>
                                <input type="email" class="form-control" placeholder="email@example.com"
                                    value="{{ old('email', $patient->email) }}" name="email">
                            </div>
                        </div>
                        <div class="row">

                            <div class="form-group col-10">
                                <label>Address</label>
                                <textarea name="address" class="form-control" id="address" cols="30" rows="3" >{{$patient->address}}</textarea>

                            </div>

                        </div>
                    </div>
                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-10">
                                <label>Birthdate</label>
                                <input type="date" name="birthdate" value="{{ old('birthdate', $patient->birthdate) }}"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-5">
                                <label>Gender</label>
                                <select name="gender" id="gender" class="form-control">
                                    <option value="">Select Gender</option>
                                    <option value="male" @if ($patient->gender == 'male') selected @endif >Male</option>
                                    <option value="female"  @if ($patient->gender == 'female') selected @endif >Female</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="row">

                                <!-- <div class="col-9"></div> -->
                                <div class="col-10" style="display:flex;justify-content:center;">
                                    <button type="submit" class="btn btn-primary"
                                        style="width: 33%; margin-top:20px;">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </form>
        </div>
        <!-- /.form-box -->
    </div><!-- /.card -->

    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
@endsection
