@extends ('../welcome')

@section('content')
    <div class="card-body">

        <div class=" row">
            <label class="col-sm-2 col-form-label">Name :</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->name }} </label>
        </div>

        <div class=" row">
            <label class="col-sm-2 col-form-label">Phone :</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->phone }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">Address :</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->address }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">Rate :</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->rate }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">Time From:</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->from }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">Time To:</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->to }} </label>
        </div>

        <div class=" row">
            <label class="col-sm-2 col-form-label">Description :</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->description }} </label>
        </div>

        <div class=" row">
            <label class="col-sm-2 col-form-label">Specialties :</label>
            <label class="col-sm-4 col-form-label">
                @foreach ($hospital->speciality as $key => $speciality)
                    @if ($key === count($hospital->speciality) - 1)
                        {{ $speciality->name_en }}
                    @else
                        {{ $speciality->name_en }},
                    @endif
                @endforeach
            </label>
        </div>

        <div class=" row">
            <label class="col-sm-2 col-form-label">Hospital Image :</label>
            <a href="{{ URL::to('/') }}/images/{{ $hospital->image }}">
                <img src="{{ $hospital->getFirstMediaUrl($hospital->id) ? $hospital->getFirstMediaUrl($hospital->id) : asset('images/anime3.png') }}"
                    width="120px">
            </a>
        </div>

        <div class=" row">
            <label class="col-sm-2 col-form-label">Created_by :</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->user->name }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">Created_at :</label>
            <label class="col-sm-4 col-form-label">{{ $hospital->created_at }} </label>
        </div>
    </div>

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Hospital</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to Reject this Hospital ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('hospitals.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
