@extends ('../welcome')


@section('content')
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"><strong>Hospitals</strong></h4>
            @if (auth()->user()->type == 'admin')
            <div class="mx-3" style="position: absolute; right: 0;">
                    <a href="{{ route('hospitals.create') }}" class="btn btn-default" style="float:right">
                        <i class="fas fa-plus"></i>
                    </a>
                <a href="{{ route('hospitals.assign') }}">
                    <button type="button" title="Assign Doctor" class="btn btn-primary">
                        Assign Doctor
                    </button>
                </a>
            </div>

            @endif
        </div>
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Address</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($hospitals as $hospital)
                        <tr>
                            <td>{{ $hospital->id }}</td>
                            <td>{{ $hospital->name }} </td>
                            <td>{{ $hospital->phone }} </td>
                            <td>{{ $hospital->address }} </td>
                            <td style="text-align:center;">
                                <div class="row">
                                    <a class="btn btn-info" title="Show"
                                        href="{{ route('hospitals.show', $hospital->id) }}">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a class="btn btn-warning ml-2" title="edit"
                                        href="{{ route('hospitals.edit', $hospital->id) }}">
                                        <i class="fa fa-pen"> </i>
                                    </a>

                                    <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                        data-id="{{ $hospital->id }}" data-toggle="modal"
                                        data-target="#exampleModalCenter">
                                        <i class="fa fa-ban"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('hospitals.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
