@extends ('../welcome')


@section('content')
    <style>
        .input:focus {
            outline: none !important;
            border: 1px solid red;
            box-shadow: 0 0 10px red;
        }
    </style>
    

    <form action="{{ route('hospitals.store') }}" method="POST" enctype="multipart/form-data">
        <div class="card col-4">
            <div class="card-header">
                <p class="header-text" style="text-align:center">Add New Hospital</p>
            </div>
            <div class="card-body">
                @csrf
                <div class="row">
                    <div class="col-12">
                        <div class="input-group mb-3">
                            <input type="text" name="name" class="form-control" placeholder="Name" required autofocus>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="input-group mb-3">
                            <input type="text" name="description" class="form-control" placeholder="Description" required
                                autofocus>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="input-group mb-3">
                            <input type="number" name="phone" class="form-control" placeholder="Phone" required
                                autofocus>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="input-group mb-3">
                            <input type="number" name="whatsapp_number" class="form-control" placeholder="Whats App"
                                required autofocus>
                        </div>
                    </div>

                    <div class="col-12 my-3">
                        <div class="row">
                            <div class="col-6 input-group mb-3">
                                <label for="timeFrom">From</label>
                                <input type="time" id="timeFrom" name="from" class="form-control"
                                    placeholder="Open Hours" required autofocus>
                            </div>

                            <div class="col-6 input-group mb-3">
                                <label for="timeTo">To</label>
                                <input type="time" id="timeTo" name="to" class="form-control"
                                    placeholder="Open Hours" required autofocus>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 my-3">
                        <label for="doctorSearch">Select Specialties:</label>
                        <select name="specialties[]" id="specialties" multiple class="select2 form-control">
                            <option value=""></option>
                            @foreach ($specialties as $specialty)
                                <option value="{{ $specialty->id }}">{{ $specialty->name_en }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-12">
                        <div class="input-group mb-3">
                            <textarea name="address" id="address" cols="30" rows="3" class="form-control" placeholder="Address"></textarea>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="input-group mb-3">
                            <div class="custom-file">
                                <input name="image" type="file" class="custom-file-input" id="inputGroupFile01">
                                <label class="custom-file-label" for="inputGroupFile01">Choose file</label>
                            </div>
                        </div>
                    </div>


                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-info">Submit</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
