@extends ('../welcome')

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('hospitalsAssign.store') }}" method="POST">
            @csrf
            <div class="form-group">
                <label>Select Doctor</label>
                <select name="doctor" class="form-control select2">
                    <option></option>
                    @foreach ($doctors as $doctor)
                        <option value="{{ $doctor->id }}">{{ $doctor->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label>Select Hospital</label>
                <select name="hospital" class="form-control select2">
                    <option></option>
                    @foreach ($hospitals as $hospital)
                        <option value="{{ $hospital->id }}">{{ $hospital->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label>AM Time (from - to)</label>
                <div class="d-flex">
                    <input type="time" name="amfrom" class="form-control mx-1" required>
                    <input type="time" name="amto" class="form-control mx-1" required>
                </div>
            </div>

            <div class="form-group">
                <label>PM Time (from - to)</label>
                <div class="d-flex">
                    <input type="time" name="pmfrom" class="form-control mx-1" required>
                    <input type="time" name="pmto" class="form-control mx-1" required>
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Assign Hospital</button>
        </form>
    </div>
</div>

<script>
    $('.select2').select2({
        placeholder: 'Select',
        allowClear: true
    });
</script>
@endsection
