@extends ('../welcome')

@section('content')
    <div class="d-flex justify-end">
        <h3 class="mb-3">Pending Doctor Requests</h3>
    </div>

    <table id="pending-doctors" class="table table-sm table-hover" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th></th>
                <th>Name</th>
                <th>Speciality</th>
                <th>Email</th>
                <th>Phone</th>
                <th>City</th>
                <th>Ragion</th>
                <th>Actions</th>
            </tr>
        </thead>
    </table>
@endsection

@push('scripts')
<script>
    $(document).ready(function () {
        var url = window.location.origin + '/doctor-requests';
        var table = $('#pending-doctors').DataTable({
            ajax: '{{ route("doctors.pending-list") }}',
            columns: [
                {
                    data: null,
                    orderable: false,
                    className: 'text-center',
                    render: function (data, type, row) {
                        return '<img src="' + (data.image ?? '{{ asset("images/anime3.png") }}') + '" class="avatar border rounded-circle">';
                    }
                },
                { data: 'name' },
                { data: 'specialty' },
                { data: 'email' },
                { data: 'phone' },
                { data: 'city' },
                { data: 'ragion' },
                {
                    data: null,
                    orderable: false,
                    className: 'text-center',
                    render: function (data) {
                        return `
                            <a href="/doctors/${data.id}" class="btn btn-sm btn-info" title="View">
                                <i class="fa fa-eye"></i>
                            </a>
                            <form method="POST" action="/doctors/${data.id}" style="display:inline;" onsubmit="return confirm('Accept this doctor?');">
                                <input type="hidden" name="_token" value="${$('meta[name="csrf-token"]').attr('content')}">
                                <input type="hidden" name="_method" value="PUT">
                                <input type="hidden" name="status" value="accept">
                                <button type="submit" class="btn btn-sm btn-success" title="Accept">
                                    <i class="fa fa-check"></i>
                                </button>
                            </form>
                            <form method="POST" action="/doctors/${data.id}" style="display:inline;" onsubmit="return confirm('Reject this doctor?');">
                                <input type="hidden" name="_token" value="${$('meta[name="csrf-token"]').attr('content')}">
                                <input type="hidden" name="_method" value="PUT">
                                <input type="hidden" name="status" value="reject">
                                <button type="submit" class="btn btn-sm btn-danger" title="Reject">
                                    <i class="fa fa-times"></i>
                                </button>
                            </form>
                        `;
                    }
                }
            ]
        });
    });
</script>
@endpush
