@extends ('../welcome')
<!-- namespace App; -->


@section('content')
    <div class="card">
        <div class="card-body register-card-body mt-5 ml-4">

            <form action="{{ route('doctors.updateDoctor', $doctor->id) }}" method="POST"  enctype="multipart/form-data">
                @csrf
                <input type="hidden" value="{{ $doctor->id }}" name="id">
                <div class="row">
                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-10">
                                <label>Name</label>
                                <input type="text" name="name" value="{{ old('name', $doctor->name) }}"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-5">
                                <label>Phone</label>
                                <input type="tel" class="form-control" value="{{ old('phone', $doctor->phone) }}"
                                    name="phone">
                            </div>
                            <div class="form-group col-5">
                                <label>Email</label>
                                <input type="email" class="form-control" placeholder="email@example.com"
                                    value="{{ old('email', $doctor->email) }}" name="email">
                            </div>
                        </div>
                        <div class="row">

                            <div class="form-group col-3">
                                <label>State</label>
                                <input type="text" class="form-control" value="{{ old('state', $doctor->state) }}"
                                    name="state">
                            </div>
                            <div class="form-group col-3">
                                <label>City</label>
                                <input type="text" class="form-control" value="{{ old('city', $doctor->city) }}"
                                    name="city">
                            </div>
                            <div class="form-group col-3">
                                <label>Neighborhood/Area</label>
                                <input type="text" class="form-control" value="{{ old('ragion', $doctor->ragion) }}"
                                    name="ragion" placeholder="Neighborhood or Area">
                            </div>

                        </div>
                    </div>
                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-10">
                                <label>Summary</label>
                                <input type="text" name="summary" value="{{ old('summary', $doctor->summary) }}"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-5">
                                <label>Gender</label>
                                <select name="gender" id="gender" class="form-control">
                                    <option value="">Select Gender</option>
                                    <option value="male" @if ($doctor->gender == 'male') selected @endif >Male</option>
                                    <option value="female"  @if ($doctor->gender == 'female') selected @endif >Female</option>
                                </select>
                            </div>
                            <div class="form-group col-5">
                                <label>Job Title</label>
                                <input type="text" class="form-control" placeholder="job title"
                                    value="{{ old('job_title', $doctor->job_title) }}" name="job_title">
                            </div>

                            <div class="form-group col-5">
                                <label>Secretary Number</label>
                                <input type="text" class="form-control" placeholder="Secretary Number"
                                    value="{{ old('secretary_number', $doctor->secretary_number) }}" name="secretary_number">
                            </div>

                            <div class="form-group col-5">
                                <label>Price (EGP)</label>
                                <input type="number" step="0.01" class="form-control" placeholder="0.00"
                                    value="{{ old('price', $doctor->price) }}" name="price">
                            </div>

                            <div class="form-group col-5">
                                <label>Speciality:</label>
                                <select name="speciality_id" id="speciality_id" class="form-control">
                                    <option hidden value="">select speciality</option>
                                    @foreach ($specialities as $speciality )
                                    <option @if($doctor->specialty_id === $speciality->id ) selected @endif    value="{{$speciality->id}}">{{$speciality->name_en}}</option>
                                    @endforeach
                                </select>
                            </div>


                            <div class="form-group col-5">
                                <label>Profile Image:</label>
                                <input type="file" name="avatar" class="form-control">
                                @if($doctor->getFirstMediaUrl($doctor->phone))
                                    <small class="text-muted">Current image:</small>
                                    <img src="{{ $doctor->getFirstMediaUrl($doctor->phone) }}" alt="Current Image" class="img-thumbnail mt-2" style="max-width: 100px;">
                                @endif
                            </div>
                        </div>
                    </div>
                        <div class="col-8 justify-center my-5">
                            @foreach ($assignedClinics as $index => $assigned)
                                <div class="row">
                                    <div class="form-group col-4">
                                        <label>Clinic</label>
                                        <select name="clinics[{{ $index }}][clinic_id]" class="form-control">
                                            @foreach ($clinics as $clinic)
                                                <option value="{{ $clinic->id }}" {{ $assigned->clinic_id == $clinic->id ? 'selected' : '' }}>
                                                    {{ $clinic->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-4">
                                        <label>AM Time (from - to)</label>
                                        @php $am = json_decode($assigned->am, true); @endphp
                                        <input type="text" name="clinics[{{ $index }}][am_from]" value="{{ $am['from'] ?? '' }}" placeholder="From" class="form-control mb-1">
                                        <input type="text" name="clinics[{{ $index }}][am_to]" value="{{ $am['to'] ?? '' }}" placeholder="To" class="form-control">
                                    </div>
                                    <div class="form-group col-4">
                                        <label>PM Time (from - to)</label>
                                        @php $pm = json_decode($assigned->pm, true); @endphp
                                        <input type="text" name="clinics[{{ $index }}][pm_from]" value="{{ $pm['from'] ?? '' }}" placeholder="From" class="form-control mb-1">
                                        <input type="text" name="clinics[{{ $index }}][pm_to]" value="{{ $pm['to'] ?? '' }}" placeholder="To" class="form-control">
                                    </div>
                                </div>
                            @endforeach
                            </div>
                        <div class="col-12">
                            <div class="row">

                                <!-- <div class="col-9"></div> -->
                                <div class="col-10" style="display:flex;justify-content:center;">
                                    <button type="submit" class="btn btn-primary"
                                        style="width: 33%; margin-top:20px;">Submit</button>
                                </div>
                            </div>
                        </div>
                </div>
            </form>
        </div>
        <!-- /.form-box -->
    </div><!-- /.card -->

    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
@endsection
