@extends ('../welcome')


@section('content')
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><strong>Clinics</strong></h4>
                <div class="col-12" style="position: relative;">
                    @if (auth()->user()->type == 'admin')
                        <div class="mx-3" style="position: absolute; right: 0;">
                            <a href="{{ route('clinics.create') }}">
                                <button type="button" title="Add Clinic" class="btn btn-success">
                                    Add New
                                </button>
                            </a>
                            <a href="{{ route('clinics.assign') }}">
                                <button type="button" title="Add Clinic" class="btn btn-primary">
                                    Assign Doctor
                                </button>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th class="filters">#</th>
                            <th class="filters">Name</th>
                            <th class="filters">Phone</th>
                            <th class="filters">Address</th>
                            {{-- <th class="filters">Description</th> --}}
                            {{-- <th class="filters">Rate</th> --}}
                            {{-- <th class="filters">Created By</th> --}}
                            <th class="filters">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($clinics as $clinic)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $clinic->name }} </td>
                                <td>{{ $clinic->phone }} </td>
                                <td>{{ $clinic->address }} </td>
                                {{-- <td>{{$clinic->description}} </td> --}}
                                {{-- <td>{{$clinic->rate}} </td> --}}
                                {{-- <td>{{$clinic->created_by}} </td> --}}
                                <td style="text-align:center;">
                                    <div class="row">
                                        <a class="btn btn-info" title="Show"
                                            href="{{ route('clinics.show', $clinic->id) }}">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <a class="btn btn-warning ml-2" title="edit"
                                            href="{{ route('clinics.edit', $clinic->id) }}">
                                            <i class="fa fa-pen"> </i>
                                        </a>

                                        <a class="btn btn-danger ml-2" title="Delete"
                                            href="{{ route('clinics.delete', $clinic->id) }}">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
