@extends ('../welcome')

@section('content')
    <style>
        .img-fluid {
            max-width: 70%;
            height: auto;
            border-radius: 100%;
            margin-left: 15%
        }
    </style>
    <div class="card col-3">
        <div class="card-header">
            <img class="img-fluid" src="{{ URL::to('/') }}/images/{{ $speciality->image }}"
                alt="{{ URL::to('/') }}/images/{{ $speciality->image }}">
        </div>
        <div class="card-body">
            <div class=" row">
                <label class="col-sm-6 col-form-label">English Name :</label>
                <label class="col-sm-4 col-form-label">{{ $speciality->name_en }} </label>
            </div>

            <div class=" row">
                <label class="col-sm-6 col-form-label">Arabic Name :</label>
                <label class="col-sm-4 col-form-label">{{ $speciality->name_ar }} </label>
            </div>

        </div>
        <div class="card-footer">

            <div style="float:right">
                <a class="btn btn-info" title="Edit" href="{{ route('specialities.edit', $speciality->id) }}">
                    Edit
                </a>
                @if (count($speciality->doctors) == 0)
                    <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                        data-id="{{ $speciality->id }}" data-toggle="modal" data-target="#exampleModalCenter">
                        Delete
                    </button>
                @endif
            </div>
        </div>
    </div>
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('specialities.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
