@extends ('../welcome')


@section('content')
    <!-- /.row -->
    <div class="card">
        <div class="card-header">
            <h4 class="card-title"><strong>Specialty</strong></h3>
                <a class="btn btn-light active" style="margin-left:2%;margin-top: -5px;" title="create"
                    href="{{ route('specialities.create') }}">
                    <li class="fas fa-plus"></li>
                </a>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name en</th>
                        <th>Name ar</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($specialities as $speciality)
                        <tr>
                            <td># {{ $speciality->id }}</td>
                            <td>{{ $speciality->name_en }} </td>
                            <td>{{ $speciality->name_ar }} </td>
                            <td>
                                <a class="btn btn-primary" title="Edit"
                                    href="{{ route('specialities.edit', $speciality->id) }}">
                                    <i class="fa fa-pen"></i>
                                </a>
                                <a class="btn btn-warning" title="Show"
                                    href="{{ route('specialities.show', $speciality->id) }}">
                                    <i class="fa fa-eye"></i>
                                </a>
                                    <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                        data-id="{{ $speciality->id }}" data-toggle="modal"
                                        data-target="#exampleModalCenter">
                                        <i class="fa fa-ban"></i>
                                    </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalCenter" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Delete Record</h5>
                        </div>
                        <div class="modal-body">
                            <p>Are you sure to delete this record ?</p>
                        </div>
                        <form class="modal-footer" method="post">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('specialities.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
