<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class RegistsNotification extends Notification
{
    use Queueable;
    public $registData;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($registData)
    {
        //
        $this->registData = $registData;

    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail','database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        // dd($notifiable);
        return (new MailMessage)                    
            ->name($this->registData['name'])
            ->line($this->registData['body'])
            // ->action($this->registData['RegistText'])
            ->line($this->registData['thanks']);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            // 'Regist_id' => $this->registData['Regist_id']
        ];
    }
}
