<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Hospital extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;
    protected $guarded = [];
    protected $guard = 'hospitals';
    protected $table = 'hospitals';
    
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function speciality()
    {
        return $this->belongsToMany(Speciality::class, 'hospital_specialty', 'hospital_id', 'specialty_id');
    }
    
    public function doctors()
{
    return $this->belongsToMany(Doctor::class, 'doctor_hospital')
                ->withPivot('am', 'pm')
                ->withTimestamps();
}

}
