<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClinicDoctor extends Model
{
    use HasFactory;

    protected $table = 'clinic_doctor';

    protected $fillable = [
        'am',
        'pm',
        'doctor_id',
        'clinic_id',
    ];

    public function doctor()
    {
        return $this->belongsTo(Doctor::class, 'doctor_id');
    }

    public function clinic()
    {
        return $this->belongsToMany(Clinic::class, 'clinic_id');
    }
}
