<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App;

class SpecialityResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        $image = asset('images/' . $this->image);

        return [
            'id' => $this->id,
            'name' => $lang == 'en'? $this->name_en : $this->name_ar,
            'image' => $image ?? '', 
        ];
    }
}
