<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SliderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        $image = asset('images/' . $this->image);

        return [
            'id' => $this->id,
            'description' => $lang == 'en'? $this->description_en : $this->description_ar,
            'image' => $image ?? '', 
        ];
    }
}
