<?php

namespace App\Http\Controllers;

use App\Models\Doctor;
use App\Models\Patient;
use App\Models\User;
use App\Models\Role;
use App\Models\Permission;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\hash;
use Illuminate\Http\Request;

use function PHPUnit\Framework\isEmpty;

class UserController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::get();
        return view('users.index',compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {

        return view('users.show',compact('user'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
public function edit(User $user)
{
    $roles = Role::all();
    $permissions = Permission::all();
    $userRoles = $user->roles->pluck('id')->toArray();
    $userPermissions = $user->permissions->pluck('id')->toArray();

    return view('users.edit', compact('user', 'roles', 'permissions', 'userRoles', 'userPermissions'));
}


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
        ]);
        $user->update($request->all());


        return redirect()->route('users.index')
                        ->with('success','user updated successfully');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user , Request $request)
    {

        try{
            $user->delete();

            $is_api_request = $request->route()->getPrefix() === 'api';
            if($is_api_request == true){
                return response()->json([
                    'message' => 'User Deleted successfully'
                ]);
            }else{
                return redirect()->route('users.index')
                    ->with('success','User deleted successfully');
            }


        }catch(Exception $ex){
            return response()->json([
                "message" => $ex->getMessage()
            ]);
        }

    }

    public function profile()
    {
        $id = Auth::user()->id;
        $user = User::find($id);
        return view('auth.profile' , compact('user'));
    }

    public function editProfile(User $user){
        return view('auth.editProfile',compact('user'));
    }

    public function updateProfile(Request $request, User $user)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'password' => ['nullable','confirmed', 'min:6']
        ]);

        if($request->password != NULL){
            $user->update([
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make($request->password)
            ]);

        }else{
            $user->update([
                'name' => $request->name,
                'email' => $request->email
            ]);
        }

        return redirect()->route('profile')
                        ->with('success','Profile updated successfully');
    }
}
