<?php

namespace App\Http\Controllers;

use App\Models\Speciality;
use Illuminate\Http\Request;

class SpecialityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $specialities = Speciality::get();
        return view('Specialities.index', compact('specialities'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Specialities.create');
     
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $speciality = new Speciality();
        $speciality->name_ar = $request->name_ar;
        $speciality->name_en = $request->name_en;

        if($request->hasFile('image')){
            $speciality->image = $request['image']->getClientOriginalName();
            // $imageName = $request->image .'.'.$request->image->extension();
            $request->image->move(public_path('images'), $speciality->image);
        }

        $speciality->save();

        return redirect()->route('specialities.index')
                        ->with('success','Speciality created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Speciality  $speciality
     * @return \Illuminate\Http\Response
     */
    public function show(Speciality $speciality)
    {
        //
        return view('Specialities.show', compact('speciality'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Speciality  $speciality
     * @return \Illuminate\Http\Response
     */
    public function edit(Speciality $speciality)
    {
        //
        return view('Specialities.edit', compact('speciality'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Speciality  $speciality
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Speciality $speciality)
    {
        //
        $speciality->name_ar = $request->name_ar;
        $speciality->name_en = $request->name_en;

        if($request->hasFile('image')){
            $speciality->image = $request['image']->getClientOriginalName();
            // $imageName = $request->image .'.'.$request->image->extension();
            $request->image->move(public_path('images'), $speciality->image);
        }
        
        $speciality->save();

        return redirect()->route('specialities.show', $speciality->id)
                        ->with('success','Speciality updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Speciality  $speciality
     * @return \Illuminate\Http\Response
     */
    public function destroy(Speciality $speciality)
    {
        $speciality->delete();
        return redirect()->route('specialities.index')
        ->with('success','Speciality deleted successfully');
    }
}
