<?php

namespace App\Http\Controllers;

use App\Models\Hospital;
use Exception;
use Illuminate\Http\Request;

class HospitalsController extends Controller
{
    //

    public function index(){
        $hospitals = Hospital::get();
        return view('hospitals.index',compact('hospitals'));
    }

    public function show(Request $request){
        try{
            $hospital = Hospital::findOrFail($request->id);
            return view('hospitals.show' , compact('hospital'));
        }catch(Exception $ex){
            return redirect()->back()->with('error' , $ex->getMessage());
        }
    }

    public function create(){
        return view('hospitals.create');
    }

    public function store(Request $request){
        try{
            Hospital::create([
                'name'=>$request->name,
                'description' => $request->description,
                'phone' => $request->phone,
                'address' => $request->address,
                'Date' => $request->Date,
                'created_by' => auth()->user()->id,
        ]);
            return redirect()->route('hospitals.index')->with('success' , 'Hospital Created Successfully');
        }catch(Exception $ex){
            return redirect()->back()->with('error' , $ex->getMessage());
        }
    }

    public function edit(Request $request){
        $hospital = Hospital::findOrFail($request->id);
        return view('hospitals.edit' , compact('hospital'));
    }

    public function update(Request $request){
        $hospital_id = $request->id;
        $hospital = Hospital::findorFail($hospital_id);
        try{

            $hospital->update($request->all());

            return redirect()->route('hospitals.index')->with('success','Hospital Updated Successfully');
        }catch(Exception $ex){
            return redirect()->back()->with('error' , $ex->getMessage());
        }
    }

    public function delete(Request $request){
        try{
            $hospital_id = $request->id;
            $hospital = Hospital::findorFail($hospital_id);
            $hospital->delete();

            return redirect()->route('hospitals.index')->with('success','Hospital Deleted Successfully');

        }catch(Exception $ex){
            return redirect()->back()->with('error' , $ex->getMessage());
        }
    }
}
