<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Doctor;
use App\Models\Patient;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Illuminate\Support\Facades\DB;
use App\Models\Role;
use App\Models\Permission;
use Exception;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */

    public function index()
    {
        $users = User::get();
        return view('users.index', compact('users'));
    }

    public function create()
    {
        $roles = Role::get();
        $permissions = Permission::get();
        return view('users.create', compact('roles', 'permissions'));
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
        try {
            $request->validate([
                'name' => ['required', 'string', 'max:255'],
                'email' => ['nullable', 'string', 'email', 'max:255', 'unique:users'],
                'phone' => ['required', 'numeric', 'unique:users'],
                'type' => ['required'],
                'password' => ['confirmed', Rules\Password::defaults()],
            ]);

            $user = User::create([
                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'type' => $request->type,
                'password' => Hash::make($request->password),
            ]);

            if ($request->roles) {
                $user->attachRoles($request->roles);
            }
            if ($request->permissions) {
                $user->attachPermissions($request->permissions);
            }
            if ($user->type == 'Doctor') {
                $doctor = new Doctor();
                $doctor->name = $user->name;
                $doctor->phone = $user->phone;
                $doctor->email = $user->email;
                $doctor->save();
            } else if ($user->type == 'Patient') {
                $patient = new Patient();
                $patient->name = $user->name;
                $patient->phone = $user->phone;
                $patient->email = $user->email;
                $patient->save();
            } else {
                return response()->json([
                    'message' => 'type of user not defined'
                ]);
            }

            $is_api_request = $request->route()->getPrefix() === 'api';

            if ($is_api_request == true) {
                return response()->json([
                    'message' => 'User Added successfully'
                ]);
            } else {
                return redirect()->route('users.index')
                    ->with('success', 'User Added successfully');
            }
        } catch (Exception $ex) {
            return response()->json([
                'message' => $ex->getMessage()
            ]);
        }
    }
}
