<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Providers\RouteServiceProvider;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     *
     * @param  \App\Http\Requests\Auth\LoginRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(LoginRequest $request)
    {
        try{
        $request->authenticate();
        $request->session()->regenerate();

        $user = Auth::user();

        $success['token'] =  $user->createToken('MyApp')->plainTextToken;
        $success['id'] =  $user->id;

        $is_api_request = $request->route()->getPrefix() === 'api';
        if($is_api_request == true){
            return response()->json(['success' => $success],200);
        }else{
            return redirect()->intended(RouteServiceProvider::HOME);
        }
        }catch(Exception $ex){
            return  redirect()->back()->with('error', $ex->getMessage());

        }



    }

    /**
     * Destroy an authenticated session.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(Request $request)
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}
