<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\TermsAndCondition;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class TermsAndConditionController extends Controller
{
    /**
     * Get the active terms and conditions
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getTerms(Request $request)
    {
        try {
            $lang = $request->header('lang', 'en');
            $identifier = $request->get('identifier', 'terms'); // Default to 'terms', can be 'privacy'
            
            // Validate identifier
            if (!in_array($identifier, ['terms', 'privacy'])) {
                return response()->json([
                    'statusCode' => 400,
                    'message' => $lang == 'en' ? 'Invalid identifier. Use "terms" or "privacy"' : 'معرف غير صالح. استخدم "terms" أو "privacy"',
                    'data' => null,
                ], 400);
            }
            
            $terms = TermsAndCondition::getActiveTerms($identifier);

            if (!$terms) {
                $message = $identifier == 'terms' 
                    ? ($lang == 'en' ? 'Terms and conditions not found' : 'الشروط والأحكام غير موجودة')
                    : ($lang == 'en' ? 'Privacy policy not found' : 'سياسة الخصوصية غير موجودة');
                    
                return response()->json([
                    'statusCode' => 404,
                    'message' => $message,
                    'data' => null,
                ], 404);
            }

            $successMessage = $identifier == 'terms'
                ? ($lang == 'en' ? 'Terms and conditions retrieved successfully' : 'تم جلب الشروط والأحكام بنجاح')
                : ($lang == 'en' ? 'Privacy policy retrieved successfully' : 'تم جلب سياسة الخصوصية بنجاح');

            return response()->json([
                'statusCode' => 200,
                'message' => $successMessage,
                'data' => [
                    'id' => $terms->id,
                    'identifier' => $terms->identifier,
                    'title' => $lang == 'ar' && $terms->title_ar ? $terms->title_ar : $terms->title,
                    'body' => $lang == 'ar' && $terms->body_ar ? $terms->body_ar : $terms->body,
                    'title_en' => $terms->title,
                    'body_en' => $terms->body,
                    'title_ar' => $terms->title_ar,
                    'body_ar' => $terms->body_ar,
                ],
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'statusCode' => 500,
                'message' => $lang == 'en' ? 'Failed to retrieve terms' : 'فشل في جلب الشروط والأحكام',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}

