<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Slider;
use App\Http\Resources\SliderResource;

class SliderController extends Controller
{
    //
    public function index(Request $request)
    {
        try{
            $lang = $request->header('lang');
            $sliders = Slider::where('is_active' , 1)->get();
            $data = SliderResource::collection($sliders);

            return response()->json([
                'statusCode' => 200,
                'data' => $data
            ]);
        }catch(Exception $e){
            return response()->json([
                'statusCode' => 500,
                'message' => $e->getMessage(),
            ]);

        }
    }
}
