<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\HospitalResource;
use App\Models\Hospital;
use Exception;
use Illuminate\Http\Request;

class HospitalController extends Controller
{
    public function index()
    {
        try {
            $hospitals = Hospital::get();
            $data = HospitalResource::collection($hospitals);

            return response()->json([
                'data' =>  $data,
                'statusCode' => 200
            ]);
        } catch (Exception $e) {
            return response()->json([
                'message' =>  $e->getMessage(),
                'statusCode' => 500
            ]);
        }
    }
}
